/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.cloud.device.service.impl;

import com.tp_link.eap.domain.system.CSSetting;
import com.tp_link.eap.domain.system.CloudDeviceInfo;
import com.tp_link.eap.domain.system.Stat;
import com.tp_link.eap.monitor.cloud.clouduser.repo.CloudUserRepository;
import com.tp_link.eap.monitor.cloud.device.a;
import com.tp_link.eap.monitor.cloud.device.b;
import com.tp_link.eap.monitor.cloud.device.repo.CloudDeviceInfoRepository;
import com.tp_link.eap.monitor.cloud.model.ControllerInfoModel;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.user.service.CSSettingService;
import com.tp_link.eap.user.service.ControllerSettingService;
import com.tp_link.eap.util.a.e;
import com.tp_link.eap.util.l;
import com.tplink.eap.cloudsdk.DeviceInfo;
import com.tplink.eap.cloudsdk.client.ConnectionStatus;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="cloudDeviceService")
public class CloudDeviceServiceImpl
implements com.tp_link.eap.monitor.cloud.device.service.a {
    @Autowired
    private CloudDeviceInfoRepository a;
    @Autowired
    private com.tp_link.eap.monitor.system.service.a b;
    @Autowired
    private CSSettingService c;
    @Autowired
    private CloudUserRepository d;
    @Autowired
    private ControllerSettingService e;
    @Autowired
    private com.tp_link.eap.monitor.cloud.cloudinterface.a f;
    @Autowired
    private com.tp_link.eap.monitor.cloud.cloudinterface.b g;
    private static final Object h = new Object();
    private static final String i = "cloudDeviceInfo";
    private static final Logger j = LoggerFactory.getLogger(CloudDeviceServiceImpl.class);
    private static final ExecutorService k = Executors.newSingleThreadExecutor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkCloudAccessEnable() {
        Object object = h;
        synchronized (object) {
            CloudDeviceInfo cloudDeviceInfo = this.a();
            return cloudDeviceInfo.isCloudAccessEnable();
        }
    }

    @Override
    public void initCloudAccessData() {
        this.a.save(this.b());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveDeviceId(String deviceId) {
        if (!l.b()) {
            return false;
        }
        if (com.tp_link.eap.util.a.e.a((String)deviceId)) {
            return false;
        }
        Object object = h;
        synchronized (object) {
            CloudDeviceInfo cloudDeviceInfo = this.a();
            String string = cloudDeviceInfo.getDeviceId();
            if (string != null && deviceId.equals(com.tp_link.eap.monitor.cloud.e.a.d(string))) {
                return true;
            }
            cloudDeviceInfo.setDeviceId(com.tp_link.eap.monitor.cloud.e.a.c(deviceId));
            cloudDeviceInfo.setRowDeviceId(true);
            this.a.save(cloudDeviceInfo);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeCloudAccessEnable(boolean enable) {
        Object object = com.tp_link.eap.b.b.a.a;
        synchronized (object) {
            Object object2 = h;
            synchronized (object2) {
                CloudDeviceInfo cloudDeviceInfo = this.a();
                cloudDeviceInfo.setCloudAccessEnable(enable);
                this.a.save(cloudDeviceInfo);
            }
            if (enable) {
                if (!com.tp_link.eap.util.a.e.a((String)this.getDeviceId())) {
                    com.tp_link.eap.monitor.cloud.a.a.a().c();
                    j.info("Cloud service is started.");
                }
                com.tp_link.eap.monitor.cloud.c.b.a().b();
            } else {
                com.tp_link.eap.monitor.cloud.a.a.a().d();
                j.info("Cloud service is stopped.");
                com.tp_link.eap.monitor.cloud.c.b.a().c();
                com.tp_link.eap.monitor.cloud.clouduser.a.a.a();
                com.tp_link.eap.monitor.cloud.proxy.a.a.d();
                this.g.a();
            }
        }
    }

    @Override
    public OperationResponse checkCloudAccessEnable(ControlType controlType, JSONObject reqObj) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("enable", this.checkCloudAccessEnable());
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public OperationResponse checkCloudAccessEnableAnon(ControlType controlType, JSONObject reqObj) {
        Stat stat = this.b.getSystemStat();
        if (null != stat && stat.isConfigured()) {
            j.warn("Controller already configured.");
            return new OperationResponse(ResErrorCode.cD);
        }
        return this.checkCloudAccessEnable(controlType, reqObj);
    }

    @Override
    public OperationResponse changeCloudAccessEnable(ControlType controlType, JSONObject reqObj) {
        if (controlType != ControlType.a && controlType != ControlType.c) {
            return new OperationResponse(ResErrorCode.g);
        }
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        if (!jSONObject.has("enable")) {
            return com.tp_link.eap.util.e.aZ;
        }
        boolean bl = jSONObject.getBoolean("enable");
        this.changeCloudAccessEnable(bl);
        return com.tp_link.eap.util.e.bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse changeCloudAccessEnableAnon(ControlType controlType, JSONObject reqObj) {
        if (controlType != ControlType.a && controlType != ControlType.c) {
            return new OperationResponse(ResErrorCode.g);
        }
        Object object = com.tp_link.eap.b.b.a.a;
        synchronized (object) {
            Stat stat = this.b.getSystemStat();
            if (null != stat && stat.isConfigured()) {
                j.warn("Controller already configured.");
                return new OperationResponse(ResErrorCode.cD);
            }
            return this.changeCloudAccessEnable(controlType, reqObj);
        }
    }

    @Override
    public String getDeviceId() {
        if (l.b()) {
            CloudDeviceInfo cloudDeviceInfo = this.a();
            String string = cloudDeviceInfo.getDeviceId();
            if (string != null) {
                return com.tp_link.eap.monitor.cloud.e.a.d(string);
            }
            return null;
        }
        String string = null;
        String string2 = com.tp_link.eap.util.a.b.a((File)new File("/tmp/sysinfo/tddp.json"));
        try {
            JSONObject jSONObject = JSONObject.fromObject((Object)string2);
            string = jSONObject.getString("device_id");
        }
        catch (JSONException jSONException) {
            j.error(jSONException.getMessage());
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDeviceIdBound() {
        if (!l.b()) {
            return;
        }
        Object object = h;
        synchronized (object) {
            CloudDeviceInfo cloudDeviceInfo = (CloudDeviceInfo)this.a.findOne((Serializable)((Object)i));
            if (cloudDeviceInfo == null) {
                this.a.save(this.b());
                return;
            }
            cloudDeviceInfo.setRowDeviceId(false);
            this.a.save(cloudDeviceInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkDeviceIdIsRow() {
        if (!l.b()) {
            return false;
        }
        Object object = h;
        synchronized (object) {
            CloudDeviceInfo cloudDeviceInfo = this.a();
            return cloudDeviceInfo.isRowDeviceId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getValidateHostBeforeBind() {
        Object object = h;
        synchronized (object) {
            CloudDeviceInfo cloudDeviceInfo = this.a();
            return cloudDeviceInfo.getValidateHost();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValidateHostBeforeBind(String validateHost) {
        Object object = h;
        synchronized (object) {
            CloudDeviceInfo cloudDeviceInfo = this.a();
            cloudDeviceInfo.setValidateHost(validateHost);
            this.a.save(cloudDeviceInfo);
        }
    }

    @Override
    public OperationResponse getControllerType(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = new JSONObject();
        boolean bl = l.b();
        jSONObject.put((Object)"isSoftController", (Object)bl);
        return new OperationResponse(ResErrorCode.a, (Object)jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse setControllerName(String controllerName) {
        if (com.tp_link.eap.util.a.e.a((String)controllerName) || controllerName.length() > 32 || controllerName.length() < 1) {
            return new OperationResponse(ResErrorCode.eK);
        }
        k.execute(() -> {
            if (this.checkCloudAccessEnable() && this.d.findByType(0) != null) {
                this.f.d(this.getDeviceId(), controllerName);
            }
        });
        Object object = com.tp_link.eap.b.b.a.a;
        synchronized (object) {
            CSSetting cSSetting = this.c.getCSSetting();
            cSSetting.setControllerName(controllerName);
            return this.c.setCSSetting(cSSetting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse setControllerName(ControlType controlType, JSONObject reqObj) {
        Object object = com.tp_link.eap.b.b.a.a;
        synchronized (object) {
            JSONObject jSONObject = reqObj.optJSONObject("params");
            if (jSONObject == null) {
                j.warn("Invalid request, params is null");
                return com.tp_link.eap.util.e.aZ;
            }
            String string = jSONObject.optString("controllerName");
            if (com.tp_link.eap.util.a.e.a((String)string)) {
                return com.tp_link.eap.util.e.aZ;
            }
            com.tp_link.eap.monitor.cloud.a.a.a();
            com.tp_link.eap.monitor.cloud.a.a.h();
            return this.setControllerName(string);
        }
    }

    @Override
    public OperationResponse getOnlineStatus(ControlType controlType, JSONObject reqObj) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("isOnline", com.tp_link.eap.monitor.cloud.a.a.a().e() == ConnectionStatus.CONNECTED);
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public OperationResponse getControllerInfo(ControlType controlType, JSONObject reqObj) {
        DeviceInfo deviceInfo = l.b() ? new b() : new a();
        DeviceInfo deviceInfo2 = deviceInfo.getDeviceInfo();
        ControllerInfoModel controllerInfoModel = new ControllerInfoModel();
        if (l.b()) {
            controllerInfoModel.setId(this.e.getControllerId());
        } else {
            controllerInfoModel.setId(com.tp_link.eap.monitor.cloud.e.a.c(this.getDeviceId()));
        }
        controllerInfoModel.setName(deviceInfo2.getAlias());
        controllerInfoModel.setType(l.b() ? 0 : 1);
        controllerInfoModel.setModel(deviceInfo2.getDeviceModel());
        controllerInfoModel.setVersion(deviceInfo2.getControllerVersion());
        controllerInfoModel.setIsConfigured(this.b.getSystemStat().isConfigured());
        return new OperationResponse(ResErrorCode.a, (Object)controllerInfoModel);
    }

    private CloudDeviceInfo a() {
        CloudDeviceInfo cloudDeviceInfo = (CloudDeviceInfo)this.a.findOne((Serializable)((Object)i));
        if (cloudDeviceInfo == null) {
            cloudDeviceInfo = (CloudDeviceInfo)this.a.save(this.b());
        }
        return cloudDeviceInfo;
    }

    private CloudDeviceInfo b() {
        CloudDeviceInfo cloudDeviceInfo = new CloudDeviceInfo();
        cloudDeviceInfo.setId(i);
        if (l.b()) {
            cloudDeviceInfo.setRowDeviceId(true);
        }
        cloudDeviceInfo.setCloudAccessEnable(true);
        return cloudDeviceInfo;
    }
}

